' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

Partial Class AddEditBug
  Inherits System.Web.UI.Page

  Private bugId As Integer = 0

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    ' Najpierw zobaczmy, czy musimy dynamicznie przeaczy aplikacje
    If Request.QueryString.Get("ApplicationId") IsNot Nothing Then
      Dim applicationId As Integer = _
              Convert.ToInt32(Request.QueryString.Get("ApplicationId"))
      Dim applicationDescription As String = _
              ListManager.GetApplicationDescription(applicationId)
      Helpers.SetApplication(applicationId, applicationDescription)
    End If

    ' Potem sprawdmy, czy mamy aplikacj
    Helpers.CheckApplicationState( _
        Server.UrlEncode(Page.AppRelativeVirtualPath & "?" & _
        Request.QueryString.ToString()))

    ' Edytujemy (bugId jest zawarty w QueryString) czy wstawiamy?
    If Request.QueryString.Get("Id") IsNot Nothing Then
      bugId = Convert.ToInt32(Request.QueryString.Get("Id"))
    End If

    If Not Page.IsPostBack Then
      LoadData()
    End If

  End Sub

  Private Sub LoadData()
    ' Najpierw musimy powiza listy wyboru z danymi
    lstFeature.DataBind()
    lstFrequency.DataBind()
    lstReproducibility.DataBind()
    lstSeverity.DataBind()

    ' Jeli edytujemy bd nastepnym krokiem bdzie pobranie bdu z bazy danych
    If (bugId > 0) Then
      ' Powi z danymi list wyboru statusu. Potrzebne tylko podczas edycji
      lstStatus.DataBind()

      Dim myBugManager As BugManager = New BugManager(Helpers.GetMemberId)
      Dim myBug As Bug = myBugManager.GetBug(bugId)
      If myBug IsNot Nothing Then
        ' Powi waciwoci bdu z kontrolkami formy. Jeli uytkownik jest menederem lub programist
        ' moe modyfikowa kade pole. Jeli uytkownik peni jedn z innych rl, moe zmieni tylko pole opisu i
        ' to wycznie wtedy, gdy to on zgosi bd.
        If User.IsInRole("Developer") _
          OrElse User.IsInRole("Manager") Then

          If lstFeature.Items.FindByValue(myBug.Feature.Value.ToString()) IsNot Nothing Then
            lstFeature.Items.FindByValue(myBug.Feature.Value.ToString()).Selected = True
          End If
          If lstReproducibility.Items.FindByValue(myBug.Reproducibility.Value.ToString()) IsNot Nothing Then
            lstReproducibility.Items.FindByValue(myBug.Reproducibility.Value.ToString()).Selected = True
          End If
          If lstFrequency.Items.FindByValue(myBug.Frequency.Value.ToString()) IsNot Nothing Then
            lstFrequency.Items.FindByValue(myBug.Frequency.Value.ToString()).Selected = True
          End If
          If lstSeverity.Items.FindByValue(myBug.Severity.Value.ToString()) IsNot Nothing Then
            lstSeverity.Items.FindByValue(myBug.Severity.Value.ToString()).Selected = True
          End If
          If lstStatus.Items.FindByValue(myBug.Status.Value.ToString()) IsNot Nothing Then
            lstStatus.Items.FindByValue(myBug.Status.Value.ToString()).Selected = True
          End If
          lstPriority.ClearSelection()
          If lstPriority.Items.FindByValue(myBug.Priority.ToString()) IsNot Nothing Then
            lstPriority.Items.FindByValue(myBug.Priority.ToString()).Selected = True
          End If
          txtTitle.Text = myBug.Title
          txtDescription.Text = myBug.Description
        Else
          lblFeature.Text = myBug.Feature.Name
          lblReproducibility.Text = myBug.Reproducibility.Name
          lblFrequency.Text = myBug.Frequency.Name
          lblSeverity.Text = myBug.Severity.Name
          lblStatus.Text = myBug.Status.Name
          lblPriority.Text = myBug.Priority.ToString()
          lblBugTitle.Text = myBug.Title

          lblFeature.Visible = True
          lblReproducibility.Visible = True
          lblFrequency.Visible = True
          lblSeverity.Visible = True
          lblStatus.Visible = True
          lblPriority.Visible = True
          lblBugTitle.Visible = True
          lblStatusLabel.Visible = True
          lblTitle.Visible = True

          lstFeature.Visible = False
          lstReproducibility.Visible = False
          lstFrequency.Visible = False
          lstSeverity.Visible = False
          lstStatus.Visible = False
          lstPriority.Visible = False
          txtTitle.Visible = False
          reqFeature.Enabled = False
          reqReproducibility.Enabled = False
          reqFrequency.Enabled = False
          reqSeverity.Enabled = False
          reqStatus.Enabled = False
          reqTitle.Enabled = False

          ' Na koniec ustalamy czy uytkownik modyfikuje swj wasny bd; w tym wypadku
          ' pozwalamy mu na edycj pola opisu.
          If CType(Session("MemberId"), Guid) = myBug.CreateMemberId Then
            txtDescription.Text = myBug.Description
          Else
            lblDescription.Text = myBug.Description.Replace(ControlChars.CrLf, "<br />")
            lblDescription.Visible = True
            txtDescription.Visible = False
          End If
        End If

      End If
      plcAddComments.Visible = True
      Me.Title = "Edycja bdu #" + bugId.ToString()
      btnSave.Text = "Aktualizuj bd"
    Else
      rowStatusAndPriority.Visible = False
      plcAddComments.Visible = False
      reqStatus.Enabled = False
      Me.Title = "Zgo nowy bd"
      btnSave.Text = "Wprowad bd"
    End If
    ' Zsynchronizuj nasz nagwek h1 z tytuem strony
    lblTitle.Text = Me.Title
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    If Page.IsValid Then
      ' Zapamitaj memberId w lokalnej zmiennej
      Dim memberId As Guid = Helpers.GetMemberId()

      Dim myBugManager As BugManager = New BugManager(memberId)
      Dim myBug As Bug
      If bugId > 0 Then
        myBug = myBugManager.GetBug(bugId)
      Else
        myBug = New Bug()
        myBug.Application.Value = Helpers.GetApplicationId()
        myBug.CreateMemberId = memberId
      End If

      ' Sprawd, czy bd pozwala na aktualizacj tylko pola opisu, czy wszystkich pl
      If lstFeature.Visible = True Then
        myBug.Title = txtTitle.Text
        myBug.Feature.Value = Convert.ToInt32(lstFeature.SelectedValue)
        myBug.Frequency.Value = Convert.ToInt32(lstFrequency.SelectedValue)
        myBug.Priority = Convert.ToInt32(lstPriority.SelectedValue)
        myBug.Reproducibility.Value = Convert.ToInt32(lstReproducibility.SelectedValue)
        myBug.Severity.Value = Convert.ToInt32(lstSeverity.SelectedValue)
        If bugId > 0 Then
          ' Aktualizuj pole statusu tylko w wypadku edycji bdu.
          myBug.Status.Value = Convert.ToInt32(lstStatus.SelectedValue)
        End If
      End If

      ' Zawsze pozwalaj na aktualizacj pola opisu i czonka zespou, ktry wprowadzi zmiany
      myBug.Description = txtDescription.Text
      myBug.UpdateMemberId = memberId

      Try
        myBugManager.InsertUpdateBug(myBug)
        If txtComments.Text.Length > 0 Then
          ' Zachowaj komentarz tylko wtedy, gdy pole komentarza zawiera tekst
          CommentManager.InsertComment(myBug.Id, txtComments.Text, memberId)
        End If
        Response.Redirect("Default.aspx")
      Catch ex As Exception
        lblErrorMessage.Text = "<br />Zapisanie bdu nie powiodo si. Prosz przejrze wprowadzone informacje i sprbowa jeszcze raz. Jeli problem bdzie si utrzymywa, prosz o kontakt z administratorem systemu.<br /><br />"
        lblErrorMessage.Visible = True
      End Try
      ' Niech analizatory poprawnoci wykonaj prac i poka komunikaty bdw.
    End If
  End Sub

  Protected Sub odsComments_Selected(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs) Handles odsComments.Selected
    If CType(e.ReturnValue, DataSet).Tables(0).Rows.Count > 0 Then
      repComments.Visible = True
    Else
      repComments.Visible = False
    End If
  End Sub
End Class
